/**
 * Created by qjon on 06.11.13.
 */
angular.module('viewer_models', [])
    .factory('MbNote', ['NotesConfiguration', function(NotesConfiguration){
        function MbNote(data){
            this.setData(data);
        }

        MbNote.prototype = {
            _hidden: false
            ,setData: function(data){
                angular.extend(this, data);
                if(!this.note_timestamp)
                {
                    this.setCurrentTimestamp()
                }
            }
            ,setCurrentTimestamp: function(){
                this.note_timestamp = Math.round(new Date().getTime() / 1000);
            }
            ,setDeleted: function(){
                this.deleted = true;
            }
            ,isEditable: function(){
                return this.user_id == NotesConfiguration.userId;
            }
            ,hide: function(){
                this._hidden = true;
            }
            ,show: function(){
                this._hidden = false;
            }
            ,isHidden: function(){
                return this._hidden;
            }
        }

        return MbNote;
    }])
    .factory('UserGroups', ['$http', '$q', 'GroupsConfiguration', function($http, $q, GroupsConfiguration){

        var UserGroups = {
            _groups: []
            ,_loaded: false
            ,load: function(){
                if(this._loaded)
                {
                    return this._groups;
                }
                var deferer = $q.defer();
                var scope = this;
                $http.post(GroupsConfiguration.host, {
                        method: 'getGroups'
                        ,user_id: GroupsConfiguration.userId
                        ,token: GroupsConfiguration.token
                    })
                    .success(function(data){
                        scope._groups = data.groups;
                        scope._loaded = true;
                        deferer.resolve(data);
                    })
                    .error(function(){

                    })
                ;

                return deferer.promise;
            }
        }

        return UserGroups;
    }])
    .factory('Users', ['$http', '$q', 'GroupsConfiguration', function($http, $q, GroupsConfiguration){

        var Users = {
            _list: {

            }
            ,_loaded: false
            ,load: function(){
                if(this._loaded)
                {
                    return this._groups;
                }
                var deferer = $q.defer();
                var scope = this;
                $http.post(GroupsConfiguration.host, {
                        method: 'getUsers'
                        ,user_id: GroupsConfiguration.userId
                        ,token: GroupsConfiguration.token
                        ,params: {
                            group_id: GroupsConfiguration.groupId
                        }
                    })
                    .success(function(data){
                        data.users.forEach(function(user){
                            scope._list[user.id] = user;
                        });
                        scope._loaded = true;
                        deferer.resolve(data);
                    })
                    .error(function(){

                    })
                ;

                return deferer.promise;
            }
            ,getUser: function(id){
                if(typeof this._list[id] != 'undefined')
                {
                    return this._list[id];
                }
                return false;
            }
        }

        return Users;
    }])

    .factory('NotesStorage', function($rootScope, MbNote, NotesConfiguration){
        var socketId = '';
        var timestamp = 0;

        var Socket = io.connect(NotesConfiguration.host);
        var msg = {title: 'Synchronizacja notatek', msg: 'Proszę czekać synchronizuję notatki'};

        Socket.on('handshakeSuccess', function(data){
            socketId = data.socket_id;
            api.sync();
        });


        Socket.on('notesSuccess', function(data){
            data.notes.forEach(api.addNote);
            timestamp = data.notes_timestamp;
            $rootScope.$broadcast('Message:delMsg', msg);
        });

        Socket.on('newNotes', function(data){
            data.notes.forEach(api.addNote);
            timestamp = data.notes_timestamp;
            $rootScope.$broadcast('Message:delMsg', msg);
        });


        Socket.on('notesError', function(data){
            console.log(data);
        });

        var notes = new Array();
        var allNotes = new Array();
        var api = {
            _hideNewNotes: false
            ,_removeNoteFromList: function(Note){
                var n = notes[Note.page_id];
                n.splice(n.indexOf(Note), 1);
                allNotes.splice(allNotes.indexOf(Note), 1);

                Note.setDeleted();


            }
            ,handshake: function(){
                $rootScope.$broadcast('Message:addMsg', msg);
                Socket.emit('handshake', { user_id: NotesConfiguration.userId});
            }
            ,find: function(id, pageId){
                var found = false;
                if(typeof notes[pageId] != 'undefined')
                {
                    notes[pageId].forEach(function(note){
                        if(note.id == id)
                        {
                            found = note;
                        }
                    });
                }
                return found;
            }
            ,addNote: function(noteData){
                var Note = api.find(noteData.id, noteData.page_id);

                if(Note !== false)
                {
                    api._removeNoteFromList(Note);
                }

                if(typeof noteData.deleted == 'undefined' || noteData.deleted == false)
                {
                    var Note = new MbNote(noteData);
                    if(api._hideNewNotes)
                    {
                        Note.hide();
                    }
                    if(typeof notes[Note.page_id] == 'undefined')
                    {
                        notes[Note.page_id] = new Array();
                    }
                    notes[Note.page_id].push(Note);
                    allNotes.push(Note);
                }
            }
            ,deleteNote: function(Note){
                api._removeNoteFromList(Note);
                Note.setCurrentTimestamp();
                this.saveNote(Note);

            }
            ,getPageNotes: function(pageId){
                if(typeof notes[pageId] == 'undefined')
                {
                    notes[pageId] = new Array();
                }
                return notes[pageId];
            }
            ,getAllNotes: function(){
                return notes;
            }
            ,saveNote: function(noteData){
                var data = {
                    socket_id: socketId,
                    user_id: NotesConfiguration.userId,
                    token: NotesConfiguration.token,
                    method: 'synchronizeNotes',
                    params:  {
                        "productcode": NotesConfiguration.productCode,
                        "notes_timestamp": timestamp,
                        "notes": [noteData]
                    }
                };
                Socket.emit('notes', data);
            }
            ,sync: function(){
                $rootScope.$broadcast('Message:addMsg', msg);
                var data = {
                    socket_id: socketId,
                    user_id: NotesConfiguration.userId,
                    token: NotesConfiguration.token,
                    method: 'synchronizeNotes',
                    params:  {
                        "productcode": NotesConfiguration.productCode,
                        "notes_timestamp": timestamp,
                        "notes": []
                    }
                };

                Socket.emit('notes', data);
            }
            ,hideShowAllNotes: function(hide){
                api._hideNewNotes = hide;
                if(hide)
                {
                    allNotes.forEach(function(Note){
                        Note.hide();
                    });
                }
                else
                {
                    allNotes.forEach(function(Note){
                        Note.show();
                    });
                }
            }
        }
        return api;
    })
;